# note: line color 6 is yellow!
set style line  1 lt 5 lc 1 pt 5  ps 2
set style line  2 lt 5 lc 3 pt 7  ps 2
set style line  3 lt 5 lc 2 pt 11 ps 2
set style line  4 lt 5 lc 4 pt 13  ps 2
set style line  5 lt 5 lc 0 pt 3  ps 2
set style line  6 lt 5 lc 7 pt 10 ps 2


set bar 2

FONTSIZE=14

set terminal epslatex color solid
set output "results_averageX_Nf=2_and_2p1p1.tex"

set xlabel "\\large{$m_{\\pi}^2 [\\mathrm{GeV}^2]$}"
set ylabel "\\large{$<x>_{u-d}$}"


legend_beta39="\\large{$N_f=2,      a = 0.079$ fm}"
legend_beta405="\\large{$N_f=2,     a = 0.063$ fm}"
legend_beta42="\\large{$N_f=2,     a = 0.051$ fm}"
legend_beta195="\\large{$N_f=2+1+1, a = 0.078$ fm}"

# hbar*c in Gev*fm
hbar_c = 0.197326968

# pion mass in GeV
m_pi = 0.13957

# <x>_u-d experimental value
av_X = 0.1646
av_X_e = 0.0027

# lattice spacings in 1/GeV
# a_beta39  = 1/2.21719101
a_beta39  = 0.079/hbar_c
# a_beta405 = 1/2.819
a_beta405  = 0.063/hbar_c
# a_beta42  = 1/3.58782
a_beta42  = 0.051/hbar_c

a_beta195 = 0.078/hbar_c

set key bottom left

set xrange[0:0.28]
set yrange[0.0:0.42]

plot "ETMC_values_Nf2_beta3.9_L_ampi_averageX_error.dat"    us ($2*$2/a_beta39/a_beta39):3:4   w errorbars ls 1 t legend_beta39,\
     "ETMC_values_Nf2_beta4.05_L_ampi_averageX_error.dat"   us ($2*$2/a_beta405/a_beta405):3:4 w errorbars ls 2 t legend_beta405,\
     "ETMC_values_Nf2_beta4.2_L_ampi_averageX_error.dat"    us ($2*$2/a_beta42/a_beta42):3:4   w errorbars ls 3 t legend_beta42,\
     "myValues_Nf=2p1p1_beta1.95_L_ampi_averageX_error.dat" us ($2*$2/a_beta195/a_beta195):3:4 w errorbars ls 4 t legend_beta195,\
     "experimentalValues_mpi_averageX_error.dat"            us ($1*$1):2:3                     w errorbars ls 5 t "\\large{CTEQ6.6C}"



set output "results_averageX_Nf=2.tex"

set yrange[0.0:0.35]

plot "ETMC_values_Nf2_beta3.9_L_ampi_averageX_error.dat"    us ($2*$2/a_beta39/a_beta39):3:4   w errorbars ls 1 t legend_beta39,\
     "ETMC_values_Nf2_beta4.05_L_ampi_averageX_error.dat"   us ($2*$2/a_beta405/a_beta405):3:4 w errorbars ls 2 t legend_beta405,\
     "ETMC_values_Nf2_beta4.2_L_ampi_averageX_error.dat"    us ($2*$2/a_beta42/a_beta42):3:4   w errorbars ls 3 t legend_beta42,\
     "experimentalValues_mpi_averageX_error.dat"            us ($1*$1):2:3                     w errorbars ls 5 t "\\large{CTEQ6.6C}"






